<?php /** @noinspection PhpUnhandledExceptionInspection */

if( ! defined( 'ABSPATH' ) ) exit;

$languages = [
    'no' => 'Norwegian',
    'en' => 'English',
    'se' => 'Swedish'
];

$sortByOptions = [
    'default'   => 'Created date',
    'updated'   => 'Updated date',
    'startDate' => 'Start date'
];

$settings = recman()->bonsy->getSettings();

$language = $settings['language'] ?? null;
$sortBy = $settings['sortBy'] ?? null;
$excerpt_length = $settings['excerpt_length'] ?? 200;
$includeExpiredCount = $settings['includeExpiredCount'] ?? 0;
$department = $settings['department'] ?? false;
$corporation = $settings['corporation'] ?? false;
?>

<div class='bonsay-block'>
    <div class="title"><h3>Fetch settings</h3></div>
    <div class="inner">

        <form method="post"
              action="<?php echo admin_url( 'admin.php?page=recman_settings&view=save_api_settings' ); ?>">

            <label for="recman_language">Language</label>
            <select name='language' id='recman_language'>
                <?php
                foreach( $languages as $val => $country ) {
                    if( $val === $language ) {
                        echo "<option value='$val' selected>$country</option>";
                    } else {
                        echo "<option value='$val'>$country</option>";
                    }
                }
                ?>
            </select>

            <label for="recman_sortBy">Sort jobs by:</label>
            <select name='sortBy' id='recman_sortBy'>
                <?php
                foreach( $sortByOptions as $sortKey => $name ) {
                    if( $sortKey === $sortBy ) {
                        echo "<option value='$sortKey' selected>$name</option>";
                    } else {
                        echo "<option value='$sortKey'>$name</option>";
                    }
                }
                ?>
            </select>

            <label for="excerpt_length">Excerpt length</label>
            <input type="number" name="excerpt_length" id="excerpt_length" value="<?php echo $excerpt_length; ?>"/>

            <label for="includeExpiredCount">Numbers of expired job posts to include
                <small>
                    Add the number of expired posts to include. See documentation for more details.
                </small></label>
            <input type="number" name="includeExpiredCount" id="includeExpiredCount"
                   value="<?php echo $includeExpiredCount; ?>"/>

            <div class='recman-checkbox' style='display:block; margin: 1em 0 0 0'>
                <input type='hidden' value="false" name='department'>
                <input type="checkbox" name="department" value="true" id="department" <?php if( $department ) {
                    echo 'checked';
                } ?> >
                <label for="department" style="margin-bottom: 0">Include department names
                    <small>
                        To show department names or to filter job posts based on departments.
                    </small>
                </label>
            </div>

            <?php if( $department ) : ?>

                <div class="subFetchSettings" id="departmentSettings">

                    <div class='recman-checkbox'>
                        <input type="checkbox" name="bonsy_filter_departments"
                               id="bonsy_filter_departments" <?php if( get_option( 'bonsy_filter_departments' ) ) {
                            echo 'checked';
                        } ?> >
                        <label for="bonsy_filter_departments" style="margin-bottom: 0">Limit job posts to selected
                            departments
                            <small>
                                Select if site should only show job posts from certain departments.
                            </small>
                        </label>
                    </div>

                    <div id="departmentList" <?php if( ! get_option( 'bonsy_filter_departments' ) ) {
                        echo 'style="display:none"';
                    } ?>>

                        <?php $department_ids = $settings['departmentIds'] ?? [];

                        foreach( recman()->bonsy->getDepartments() as $department_id => $department_name ) : ?>
                            <label>
                                <input type="checkbox" name="departmentIds[]"
                                       value="<?php echo $department_id; ?>" <?php if( in_array( $department_id, $department_ids, false ) ) {
                                    echo 'checked';
                                } ?> >
                                <?php echo $department_name; ?>
                            </label>
                        <?php endforeach; ?>

                    </div>

                </div>

            <?php endif; ?>

            <div id="departmentWarning" class="warning" style="display: none;">
                <strong>Important!</strong> Make sure your RecMan API key has privilege to fetch departments!
            </div>


            <!-- Corporation -->

            <div class='recman-checkbox' style='display:block; margin: 1em 0 0 0'>
                <input type='hidden' value="false" name='corporation'>
                <input type="checkbox" name="corporation" value="true" id="corporation" <?php if( $corporation ) {
                    echo 'checked';
                } ?>>
                <label for="corporation" style="margin-bottom: 0">Include corporation names
                    <small>
                        To show corporation names or to filter job posts based on corporation.
                    </small>
                </label>
            </div>

            <?php if( $corporation ) : ?>

                <div class="subFetchSettings" id="corporationSettings">

                    <div class='recman-checkbox'>
                        <input type="checkbox" name="bonsy_filter_corporations"
                               id="bonsy_filter_corporations" <?php if( get_option( 'bonsy_filter_corporations' ) ) {
                            echo 'checked';
                        } ?> >
                        <label for="bonsy_filter_corporations" style="margin-bottom: 0">Limit job posts to selected
                            corporations
                            <small>
                                Select if site should only show job posts from certain corporations.
                            </small>
                        </label>
                    </div>

                    <div id="corporationList" <?php if( ! get_option( 'bonsy_filter_corporations' ) ) {
                        echo 'style="display:none"';
                    } ?>>

                        <?php $corporation_ids = $settings['corporationIds'] ?? [];

                        foreach( recman()->bonsy->getCorporations() as $corporation_id => $corporation_name ) : ?>
                            <label>
                                <input type="checkbox" name="corporationIds[]"
                                       value="<?php echo $corporation_id; ?>" <?php if( in_array( $corporation_id, $corporation_ids, false ) ) {
                                    echo 'checked';
                                } ?> >
                                <?php echo $corporation_name; ?>
                            </label>
                        <?php endforeach; ?>

                    </div>

                </div>

            <?php endif; ?>

            <div id="corporationWarning" class="warning" style="display: none;">
                <strong>Important!</strong> Make sure your RecMan API key has privilege to fetch corporations!
            </div>

            <script>

                function bonsyToggleVisibility(id, show) {
                    let element = document.getElementById(id);
                    if (element) {
                        element.style.display = (show) ? 'block' : 'none';
                    }
                }

                let departmentCheckBox = document.getElementById('department');

                if (departmentCheckBox) {
                    departmentCheckBox.addEventListener('change', function () {
                        bonsyToggleVisibility('departmentWarning', (departmentCheckBox.checked));
                        bonsyToggleVisibility('departmentSettings', (departmentCheckBox.checked));
                    });
                }

                let filterDepartmentCheckBox = document.getElementById('bonsy_filter_departments');

                if (filterDepartmentCheckBox) {
                    filterDepartmentCheckBox.addEventListener('change', function () {
                        bonsyToggleVisibility('departmentList', (filterDepartmentCheckBox.checked));
                    });
                }

                let corporationCheckBox = document.getElementById('corporation');

                corporationCheckBox.addEventListener('change', function () {
                    bonsyToggleVisibility('corporationWarning', (corporationCheckBox.checked));
                    bonsyToggleVisibility('corporationSettings', (corporationCheckBox.checked));
                });

                let filterCorporationCheckBox = document.getElementById('bonsy_filter_corporations');

                if (filterCorporationCheckBox) {
                    filterCorporationCheckBox.addEventListener('change', function () {
                        bonsyToggleVisibility('corporationList', (filterCorporationCheckBox.checked));
                    });
                }


            </script>


            <div class="buttons" style="margin-top: 1em">
                <button type="submit" class="button button-primary">Save</button>
            </div>

        </form>

        <p>
            <small class="warning" style="margin-top: 1rem; display: block">
                Please note that settings are stored in your Bonsy account. If you are running the same license on both
                a local development environment and a live server, changes made in one environment will affect the
                other.
                Please sign up using a different RecMan API key if you want to separate these changes. You can contact
                Bonsy
                to let us know if an account is being used for development, so that we can convert trial mode to
                a free subscription.
            </small>
        </p>


    </div>
</div>