<div class='bonsay-block'>
    <div class="title"><h3>Individual job post page</h3></div>
    <div class="inner">

        <p>
            To link to a specific job post, you should use the <code>permalink</code> tag as your URL. By default,
            it will link to the job post on recman.no. By activating the option below, the <code>permalink</code> will
            use a WordPress page to show individual job posts.
            <a href="https://bonsy.gitbook.io/bonsay-recman-wp/job-posts/job-post-template-usage" target="_blank">
                See our documentation for more details
            </a>.
        </p>

        <!--suppress HtmlUnknownTarget -->
        <form method="post" action="options.php">

            <?php

            settings_fields( 'bonsy_job_page_section' );

            $checked = get_option( 'bonsy_show_job_locally' ) ? 'checked' : '';

            $pages = get_pages();
            $jobPage = get_option( 'bonsy_single_job_page' );

            $expired_redirect = get_option( 'bonsy_expired_redirect' );

            ?>

            <div class='recman-checkbox' style='display:block;margin-bottom: 1em;'>
                <input type='checkbox' name='bonsy_show_job_locally' id='bonsy_show_job_locally'
                       value='1' <?php echo $checked; ?> />
                <label for='bonsy_show_job_locally' class='checkboxlabel'><strong>Show individual job posts on
                        Wordpress</strong></label>
            </div>

            <?php
            $style = ( get_option( 'bonsy_show_job_locally' ) ) ? '' : 'display:none';
            $slug = '';
            ?>

            <div id="local_job_page_settings" style="<?php echo $style; ?>">

                <div class="warning info" style="margin: 2em 0">
                    The plugin need to know which page to use for showing individual job posts.
                    <a href="<?php echo admin_url( 'post-new.php?post_type=page' ); ?>">Create a WordPress page</a>
                    and assign your template to this page. Select the page that has your job post template below.
                    <a href="">Read our documentation to learn more</a>.
                </div>

                <label for="bonsy_single_job_page">
                    Select your WordPress page for individual job posts
                    <small>
                        The page must be assigned a template that are able to show job post details.
                    </small>
                </label>
                <select name='bonsy_single_job_page' id='bonsy_single_job_page'>
                    <?php if( ! $jobPage ) : ?>
                        <option disabled selected>- Select page -</option>
                    <?php endif;
                    foreach( $pages as $page ) {

                        $selected = '';
                        $page_slug = '';

                        if( $parent_link = get_permalink( wp_get_post_parent_id( $page->ID ) ) ) {
                            $page_slug = trim( str_replace( site_url(), '', $parent_link ), '/' );
                        }

                        if( (int)$jobPage === $page->ID ) {
                            $slug = $page_slug;
                            $selected = 'selected';
                        }

                        echo sprintf( '<option data-slug="%s" value="%d" %s>%s</option>', $page_slug, $page->ID, $selected, $page->post_title );
                    }
                    ?>
                </select>


                <?php

                /**
                 * Custom Job Path
                 */

                $custom_job_path_value = get_option( 'bonsy_custom_job_path' );
                $slug = ( get_option( 'bonsy_custom_job_path' ) ) ?: $slug;
                $url = rtrim( get_site_url(), '/' );

                ?>

                <label for="bonsy_custom_job_path">
                    Custom slug
                    <small style="max-width: 550px">
                        The job post will have a friendly URL which includes the parent structure from
                        the selected WordPress page. If you want a different URL structure, you can add one here.
                    </small>
                </label>
                <input type="text" name="bonsy_custom_job_path" id="bonsy_custom_job_path" value="<?php echo $custom_job_path_value ?>" />
                <div id="jobPostUrl">
                    <?php echo $url; ?>/<span id="slug" data-slug="<?php echo $slug; ?>"><?php echo $slug; ?></span>/the-job-title
                </div>

                <div id="noSlugWarning" class="warning" style="<?php if( $slug ) {
                    echo 'display:none;';
                } ?> max-width: 550px">
                    It is recommended that the job post URL has a parent slug. Please make sure to either add a custom
                    slug or define a parent page for the WordPress page you have selected as template above.
                </div>

                <script>

                    function maybeShowWarning() {
                        if (document.getElementById('slug').textContent.length === 0) {
                            document.getElementById('noSlugWarning').style.display = 'block';
                            document.getElementById('noSlugWarning').style.maxWidth = '550px';
                        } else {
                            document.getElementById('noSlugWarning').style.display = 'none';
                        }
                    }

                    function selectedPageSlug() {
                        return document.getElementById('bonsy_single_job_page').selectedOptions[0].getAttribute('data-slug');
                    }

                    let customSlug = document.getElementById('bonsy_custom_job_path');

                    customSlug.addEventListener('keyup', function () {
                        if (customSlug.value.length > 0) {
                            document.getElementById('slug').textContent = customSlug.value;
                            maybeShowWarning();
                        } else {
                            document.getElementById('slug').textContent = selectedPageSlug();
                            maybeShowWarning();
                        }
                    });

                    let jobPostPage = document.getElementById('bonsy_single_job_page');
                    jobPostPage.addEventListener('change', function () {
                        if (customSlug.value.length === 0) {
                            document.getElementById('slug').textContent = selectedPageSlug();
                            maybeShowWarning();
                        }
                    })

                </script>

                <label for="bonsy_expired_redirect">
                    Select page if job post has expired
                    <small>
                        Expired job posts will disappear when cache is updated. Choose page to show when job posts are
                        expired.
                    </small>
                </label>
                <select name='bonsy_expired_redirect' id='bonsy_expired_redirect'>
                    <option>- Select page -</option>
                    <?php foreach( $pages as $page ) {
                        $selected = ( (int)$expired_redirect === $page->ID ) ? ' selected ' : '';
                        echo sprintf( '<option value="%d" %s>%s</option>', $page->ID, $selected, $page->post_title );
                    } ?>
                </select>

                <?php

                $google_maps_api_key = get_option( 'bonsy_google_api_key' );
                echo "<label for='bonsy_google_api_key'>Google Maps API Key</label>";
                echo "<small style='margin-bottom: .5rem;display: block'>Want to utilize a Google Map in your job posts? Add your <a href='https://console.cloud.google.com/' target='_blank'>Google Maps API key</a>. Once the API key is set, you can use the WordPress shortcode <code>[job_post_map]</code> or the helper function <code>job_post_map();</code> to display the map.</small>";
                echo "<input name='bonsy_google_api_key' id='bonsy_google_api_key' type='text' placeholder='Add your Google Maps API key' value='$google_maps_api_key' />";
                ?>

                <?php
                    $gutenberg_support = get_option( 'bonsy_gutenberg_support' ) ? 'checked' : '';
                ?>

                <div class='recman-checkbox' style='display:block;margin-bottom: 1em;'>
                    <input type='checkbox' name='bonsy_gutenberg_support' id='bonsy_gutenberg_support'
                           value='1' <?php echo $gutenberg_support; ?> />
                    <label for='bonsy_gutenberg_support' class='checkboxlabel'><strong>Enable Gutenberg Support (Beta)</strong></label>
                </div>

            </div>

            <div class='buttons'>
                <?php submit_button( 'Save' ); ?>
            </div>

        </form>

        <script>

            const showJobLocally = document.getElementById('bonsy_show_job_locally');

            showJobLocally.addEventListener('change', function () {
                if (showJobLocally.checked) {
                    document.getElementById('local_job_page_settings').style.display = 'block';
                } else {
                    document.getElementById('local_job_page_settings').style.display = 'none';
                }
            });

        </script>

    </div>
</div>