<?php /** @noinspection PhpUnhandledExceptionInspection */

if( ! defined( 'ABSPATH' ) ) exit;

$cache_file = recman()->bonsy->cacheFile();

$cache_content = 'Unable to load cache content';

if( is_file( $cache_file ) ) {
    try {
        $cache_content = file_get_contents( $cache_file );
        $cache_content = json_decode( $cache_content, false, 512, JSON_THROW_ON_ERROR );
        $cache_content = json_encode( $cache_content, JSON_THROW_ON_ERROR | JSON_PRETTY_PRINT );
        $cache_content = htmlspecialchars($cache_content);
    } catch ( Throwable $e ) {
        $cache_content = $e->getMessage();
    }
}

?>

<div class='bonsay-block'>
    <div class="title"><h3>Json Cache</h3></div>
    <div class="inner">

        <div>
            <h4>Current cache file: <?php echo $cache_file; ?></h4>
            <br/>
        </div>

        <div>
            <h3>Cache Content</h3>
            <br>
            <pre><?php echo $cache_content; ?></pre>
        </div>


    </div>
</div>