<?php /** @noinspection PhpUnhandledExceptionInspection */

if( ! defined( 'ABSPATH' ) ) exit;

$expiry_date = recman()->bonsy->licenseExpiryDate();
$expiry_date = $expiry_date->format( get_option( 'date_format' ) );

$license = get_option( 'bonsy_license', 'n/a' );
if( strlen( $license ) > 5 ) {
    $license = str_repeat( '*', strlen( $license ) - 5 ) . substr( $license, -5, 5 );
}

$license_details = recman()->bonsy->getLicense();

$subscription = $license_details['subscription'] ?? false;
$subscription = ( $subscription ) ? 'Active' : 'Trial mode <br /><small>Contact Bonsy to activate subscription</small>';

$recman_api_key = $license_details['recman_api_key'] ?? false;

?>

<div class='bonsay-block'>
    <div class="title"><h3>License</h3></div>
    <div class="inner">


        <div id="license">
            <dl>
                <dt>License</dt>
                <dd><?php echo $license; ?></dd>

                <dt>Subscription</dt>
                <dd><?php echo $subscription; ?></dd>

                <dt>Expiry date</dt>
                <dd><?php echo $expiry_date; ?></dd>

                <?php if( $recman_api_key ) : ?>
                    <dt>RecMan API Key</dt>
                    <dd><?php echo $recman_api_key; ?><br><a
                                href="<?php echo wp_nonce_url( admin_url( 'admin.php?page=recman_settings&view=license&bonsy_validate_permission=1' ), 'bonsy_validate_permission' ); ?>"
                                class='button button-secondary'>Validate RecMan API key permission</a></dd>
                <?php endif; ?>

                <!--                <dt>Auto-Renew</dt>-->
                <!--                <dd>Yes</dd>-->
                <!---->
                <!--                <dt>Billing Cycle</dt>-->
                <!--                <dd>Annually (12 months)</dd>-->
            </dl>
        </div>
    </div>
</div>