<div class='bonsay-block'>
    <div class="title"><h3>Shortcode</h3></div>
    <div class="inner">

        <script src="//cdnjs.cloudflare.com/ajax/libs/highlight.js/11.7.0/highlight.min.js"></script>

        <p>
            Display job posts using a shortcode <code>[job_post_feed]</code>. This can be a convenient option if you are
            not
            familiar with PHP or are using a theme builder such as Elementor, DIVI, or Flatsome.
        </p>

        <p>
            To limit the number of jobs displayed, use the shortcode <code>[job_post_feed count="10"]</code> to show
            only 10 jobs.
        </p>

        <p>
            If there are no job posts available, the shortcode will output «No job posts available» by default. You can
            change this message by using the shortcode attribute <code>no_job_post_message</code> like this:
            <code>[job_post_feed no_job_post_message="No jobs available"]</code>.
        </p>

        <form method="post" action="options.php">

            <?php

            settings_fields( 'bonsy_shortcode_section' );
            $checked = get_option( 'bonsy_shortcode_active' ) ? 'checked' : '';
            $style = $checked ? '' : 'display:none';

            $html_template = get_option( 'bonsy_shortcode_html_template' );

            if( !$html_template || !is_string( $html_template ) ) {
                $html_template = @file_get_contents( recman()->getFilePath( "admin/view/shortcode_html_example.html" ) ) ?: '';
                update_option( 'bonsy_shortcode_html_template', $html_template );
            }

            ?>

            <div class='recman-checkbox' style='display:block;margin-bottom: 1em;'>
                <input type='checkbox' name='bonsy_shortcode_active' id='bonsy_shortcode_active'
                       value='1' <?php echo $checked; ?> />
                <label for='bonsy_shortcode_active' class='checkboxlabel'><strong>Activate shortcode</strong></label>
            </div>

            <br>

            <div id="bonsy_shortcode_settings" style="<?php echo $style; ?>">

                <label for="bonsy_shortcode_html_template">Custom Job Post Feed HTML Template</label>
                <textarea name="bonsy_shortcode_html_template" class="bonsyTextArea codeTextArea"
                          id="bonsy_shortcode_html_template"><?php echo $html_template; ?></textarea>

                <div class="warning info" style="margin: 2em 0">
                    To add fields inside your template use <code>{{ field_name }}</code> where field_name is the name of
                    the field.
                    <a href="https://bonsy.gitbook.io/bonsay-recman-wp/job-posts/displaying-fields/untitled"
                       target="_blank">See available fields here</a>.
                </div>
                <div class="warning info" style="margin: 2em 0">
                    You can add custom fields/parameters to your shortcode, for example
                    <code>[job_post_feed my_label="My Label"]</code>,
                    and then use it in your template like this <code>{{ my_label }}</code>.
                    Custom label will always override the job post field, so make sure to use non-conflicting names.
                </div>

                <?php
                $css = get_option( 'bonsy_shortcode_custom_css', '' );
                if( !$css || !is_string( $css ) ) {
                    $css = @file_get_contents( recman()->getFilePath( "admin/css/shortcode_css_example.css" ) ) ?: '';
                    update_option( 'bonsy_shortcode_custom_css', $css );
                }
                ?>

                <label for="shortcode_css">Excerpt length</label>
                <textarea name="bonsy_shortcode_custom_css" class="bonsyTextArea codeTextArea"
                          id="shortcode_css"><?php echo $css; ?></textarea>

            </div>


            <div class='buttons' style="margin-top: 1rem">
                <?php submit_button( 'Save' ); ?>
            </div>

        </form>

        <script>

            const shortcode_css = document.getElementById('shortcode_css');
            const shortcode_html = document.getElementById('bonsy_shortcode_html_template');

            const autoGrow = (el) => {
                el.style.height = '1em';
                el.style.height = (el.scrollHeight) + "px";
            }

            document.addEventListener("DOMContentLoaded", function () {
                autoGrow(shortcode_css);
                autoGrow(shortcode_html);
            });

            shortcode_css.addEventListener('input', () => autoGrow(shortcode_css));
            shortcode_html.addEventListener('input', () => autoGrow(shortcode_html));

            const formTabSupport = (e) => {
                if (e.key == 'Tab') {
                    e.preventDefault();
                    let form = e.target;
                    let s = form.selectionStart;
                    form.value = form.value.substring(0, form.selectionStart) + "\t" + form.value.substring(form.selectionEnd);
                    form.selectionEnd = s + 1;
                }
            }

            shortcode_css.addEventListener('keydown', function (e) {
                formTabSupport(e, this);
            });
            shortcode_html.addEventListener('keydown', function (e) {
                formTabSupport(e, this);
            });


            const shortCodeIsActive = document.getElementById('bonsy_shortcode_active');

            shortCodeIsActive.addEventListener('change', function () {
                if (shortCodeIsActive.checked) {
                    document.getElementById('bonsy_shortcode_settings').style.display = 'block';
                    autoGrow(shortcode_css);
                    autoGrow(shortcode_html);
                } else {
                    document.getElementById('bonsy_shortcode_settings').style.display = 'none';
                }
            });

        </script>

        <br>

        <h3 style="margin-bottom: .5rem">Shortcode for filters</h3>
        <p>
            You can also use the shortcode <code>[job_post_feed_filters]</code> to display filters for the job posts.
            It supports the following attributes: <code>field</code>, <code>title</code>, <code>reduce</code>, and
            <code>count</code>.
        </p>
        <p><code>field</code> and <code>title</code> is required. <code>reduce</code> and <code>count</code> is either
            "1" (true) or "0" (false), where reduce will reduce the filter list to only filters with available jobs when
            another filter is active. Else, it will keep the list as is. If count is set to true, it will display the
            number of jobs available for each filter. </p>
        <p>There is a class named "active" for each item that is active in
            filtered list. If you don't reduce list and the filter has no jobs, it will get the class "empty". Check
            source code to see how it is structured so you can apply your own styling.
        </p>

        <pre><code class="html">[job_post_filter field="workplace" title="Workplace" reduce="0" count="1"]</code></pre>

        <p>
            The code below is an example on how the filter will output its HTML. You can use this as a template for your
            own styling. Notice li class of "active" is added when filter is active, and "empty" means that the given
            filter
            has no result with in combination with the active filter.
        </p>

        <?php $filter_code = '<div class="job-post-filter">
    <h3>Workplace</h3>
    <ul>
        <li class="active">
            <a href="..." rel="nofollow">Oslo (1)</a>
        </li>
        <li class="empty">
            <a href="..." rel="nofollow">Stockholm (0)</a>
        </li>
        <li class="">
            <a href="..." rel="nofollow">New York (1)</a>
        </li>
    </ul>
</div>'; ?>

        <pre><code class="html"><?php echo htmlspecialchars( $filter_code ); ?></code></pre>

        <h3 style="margin: 2rem 0 .5rem 0">Shortcode for search field</h3>
        <pre><code class="language-html">[job_post_search]</code></pre>
        <p>
            This will display a free-text search field for job posts. It supports the attributes <code>label</code>,
            <code>placeholder</code> <code>button</code>. If
            you set button or label with empty value, like: <code>button=""</code> it will not display that component.
        </p>
        <p>
        <pre><code class="html">[job_post_search label="Search jobs" placeholder="Enter search here..." button="Search"]</code></pre>

        </p>
        <p>
            This will output the code below. Use the id <code>job-post-search-form</code> to apply your own styling.
        </p>


        <?php $search_code = '<form method="get" id="job-post-search-form">
    <label for="jobSearch">Search jobs</label>
    <input type="text" id="jobSearch" name="jobSearch" value="" placeholder="Enter search here...">
    <button type="submit">Search</button>
</form>
'; ?>

        <pre><code class="language-html"><?php echo htmlspecialchars( $search_code ); ?></code></pre>

        <script>hljs.highlightAll();</script>

    </div>
</div>