const registerBlockType = wp.blocks.registerBlockType;
const TextControl = wp.components.TextControl;
const InspectorControls = wp.blockEditor.InspectorControls;
const PanelBody = wp.components.PanelBody;
const createElement = wp.element.createElement;

const svgEl = createElement('svg', { viewBox: "0 0 50 50", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    createElement('path', { d: "M49.51 24.37c0 14.88-10.32 23.88-21.54 23.88h-6.6C10.33 48.25.49 39.73.49 25.63c0-14.16 9.6-23.88 21.48-23.88h6.66c11.04 0 20.88 8.52 20.88 22.62Zm-7.2-.36c0 10.02-6.36 17.46-14.28 17.46-6.78 0-13.14-5.4-13.14-15.06 0-8.64 5.34-14.28 12.12-15-1.56-.78-3.24-1.26-5.04-1.26-6.9 0-12.66 6.6-12.66 15.84 0 12.96 8.7 20.64 18.96 20.64 10.02 0 19.62-8.04 19.62-22.26 0-12.72-8.58-20.52-18.24-21.06 7.38 3.06 12.66 10.62 12.66 20.7ZM7.69 25.99c0-10.02 6.36-17.46 14.22-17.46 6.84 0 13.2 5.4 13.2 15.06 0 8.64-5.4 14.34-12.18 15 1.56.84 3.3 1.26 5.1 1.26 6.9 0 12.66-6.6 12.66-15.84 0-12.96-8.7-20.64-18.78-20.64-11.34 0-19.8 9.48-19.8 22.26 0 12.78 8.7 20.58 18.3 21.12-7.14-3-12.72-10.32-12.72-20.76Zm25.8-2.34c0-4.74-1.68-8.4-4.26-10.68-6.36-.6-12.72 4.62-12.72 13.38 0 4.74 1.68 8.4 4.2 10.74 6.42.54 12.78-4.68 12.78-13.44Z", fill: "#000" })
);

registerBlockType('bonsy-recman/job-post-field', {
    title: 'Job post field',
    icon: svgEl,
    category: 'common',
    description: 'This is awesome',
    attributes: {
        jobPostFieldName: {
            type: 'string',
            default: 'defaultValue',
        },
    },
    edit: function(props) {
        const inspectorControls = createElement(
            InspectorControls,
            {},
            createElement(
                PanelBody,
                {
                    title: 'Job Post Field Settings',
                    initialOpen: true
                },
                createElement(TextControl, {
                    label: 'Job Post Field Name',
                    value: props.attributes.jobPostFieldName,
                    onChange: function(newValue) {
                        props.setAttributes({ jobPostFieldName: newValue });
                    }
                })
            )
        );

        // Add AJAX to fetch the same data as on the front-end.
        // Use any method you prefer to fetch data from the server.
        const [dynamicContent, setDynamicContent] = wp.element.useState('Fetching...');

        wp.apiFetch({ path: `/bonsy-recman/job_post_field?name=${props.attributes.jobPostFieldName}` }).then(data => {
            setDynamicContent(data);
        });

        const blockUI = createElement(
            'div',
            {},
            dynamicContent
        );

        return [inspectorControls, blockUI];

    },
    save: function() {
        return null;
    },
});
