<?php /* Template Name: Job Post Page */
get_header(); ?>

<main>
    <article>
        <header>
            <?php
            # Get the job post name
            if( $name = get_jobpost( 'name' ) ) {
                echo "<h1>$name</h1>";
            }
            ?>
        </header>

        <article>
            <?php

            # Get company description as ingress
            if( $ingress = get_jobpost( 'companyDescription' ) ) {
                echo "<p><strong>$ingress</strong></p>";
            }

            # show the job ad
            the_jobpost( 'body' );

            ?>
        </article>

        <aside>

            <?php if( get_jobpost( 'logo' ) ) : ?>
                <div class="logo">
                    <img src='<?php the_jobpost( 'logo' ); ?>'/>
                </div>
            <?php endif; ?>

            <a href='<?php the_jobpost( 'apply' ); ?>' class='button'>Apply Job</a>

            <div>
                <?php if( get_jobpost( 'company_name' ) ) : ?>
                    <label>Company Name</label>
                    <span><?php the_jobpost( 'company_name' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'salary' ) ) : ?>
                    <label>Salary</label>
                    <span><?php the_jobpost( 'salary' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'deadline' ) ) : ?>
                    <label>Application Deadline</label>
                    <span><?php the_jobpost( 'deadline' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'workplace' ) ) : ?>
                    <label>Workplace</label>
                    <span><?php the_jobpost( 'workplace' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'title' ) ) : ?>
                    <label>Title</label>
                    <span><?php the_jobpost( 'title' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'sector' ) ) : ?>
                    <label>Sector</label>
                    <span><?php the_jobpost( 'sector' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'type' ) ) : ?>
                    <label>Extent</label>
                    <span><?php the_jobpost( 'type' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'numberOfPositions' ) ) : ?>
                    <label>Number of positions</label>
                    <span><?php the_jobpost( 'numberOfPositions' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'branchCategory' ) ) : ?>
                    <label>Branch Category</label>
                    <span><?php the_jobpost( 'branchCategory' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'branch' ) ) : ?>
                    <label>Branch</label>
                    <span><?php the_jobpost( 'branch' ); ?></span>
                <?php endif; ?>

                <?php if( get_jobpost( 'facebook' ) or get_jobpost( 'webpage' ) or get_jobpost( 'linkedin' ) ) : ?>
                    <label>Webpage</label>
                    <span>
					<ul class='noStyle adLinks'>
						<?php if( get_jobpost( 'website' ) ) : ?>
                            <li><a class='icon home' href='<?php the_jobpost( 'website' ); ?>'>Website</a></li>
                        <?php endif; ?>
                        <?php if( get_jobpost( 'facebook' ) ) : ?>
                            <li><a class='icon facebook' href='<?php the_jobpost( 'facebook' ); ?>'>Facebook</a></li>
                        <?php endif; ?>
                        <?php if( get_jobpost( 'linkedIn' ) ) : ?>
                            <li><a class='icon linkedin' href='<?php the_jobpost( 'linkedIn' ); ?>'>LinkedIn</a></li>
                        <?php endif; ?>
					</ul>
				</span>
                <?php endif; ?>

            </div>

            <?php if( have_jobpost_object( 'contacts' ) ):

                # Loop through the rows of data
                while( have_jobpost_object( 'contacts' ) ) : the_jobpost_object(); ?>

                    <div class="contactPersons">
                        <?php if( get_jobpost_object( 'image' ) ) : ?>
                            <div>
                                <?php $alt = (get_jobpost_object( 'firstName' ) and get_jobpost_object( 'lastName' )) ? get_jobpost_object( 'firstName' ) . ' ' . get_jobpost_object( 'lastName' ) : ''; ?>
                                <img src='<?php the_jobpost_object( 'image' ); ?>' alt='<?php echo $alt; ?>'/>
                            </div>
                        <?php endif; ?>
                        <div class="details">
                            <h4><?php the_jobpost_object( 'name' ); ?></h4>
                            <?php if( get_jobpost_object( 'title' ) ) : ?>
                                <span class="title"><?php the_jobpost_object( 'title' ); ?></span>
                            <?php endif; ?>
                            <?php if( get_jobpost_object( 'email' ) ) : ?>
                                <span class="email"><a
                                            href='mailto:<?php the_jobpost_object( 'email' ); ?>'><?php the_jobpost_object( 'email' ); ?></a></span>
                            <?php endif; ?>
                            <?php if( get_jobpost_object( 'mobilePhone' ) ) : ?>
                                <span class="phone"><?php the_jobpost_object( 'mobilePhone' ); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                <?php endwhile; endif; ?>

        </aside>

    </article>

    <?php
    $images = get_jobpost( 'images' );

    if( $images ) : foreach( $images as $image ) : ?>
        <section class='bigImg cWrap'>
            <img src='<?php echo $image; ?>' alt='<?php the_jobpost( 'name' ); ?>'/>
        </section>
    <?php endforeach; endif; ?>

</main>

<?php get_footer(); ?>
