<?php

/**
 * Register Gutenberg Block JavaScript
 */
add_action( 'enqueue_block_editor_assets', static function() {
    wp_enqueue_script(
        'job-post-field-block',
        recman()->getFileUrl('block.js'),
        ['wp-blocks', 'wp-element', 'wp-components', 'wp-editor']
    );
} );


/**
 * Register Gutenberg Block Type
 */
register_block_type( 'bonsy-recman/job-post-field', [
    'editor_script' => 'bonsy-recman-hello',
] );


/**
 * Handle rendering of Gutenberg block for front end
 */
add_filter( 'render_block', static function($block_content, $block) {
    # Bail if not this block
    if( $block['blockName'] !== 'bonsy-recman/job-post-field' ) return $block_content;
    # Render content
    $field_name = $block['attrs']['jobPostFieldName'] ?? 'defaultValue';
    return recman()->bonsy->get( $field_name );
}, 10, 2 );


/**
 * Handle fetching of example data when editing a job post gutenberg template
 */
add_action( 'rest_api_init', static function() {
    register_rest_route( 'bonsy-recman', '/job_post_field', array(
        'methods' => 'GET',
        'callback' => function($request) {
            $field = $request->get_param( 'name' );
            if( !$field || !is_string( $field ) ) return 'Error: unable to get name of field';
            recman()->bonsy->setExampleByFirstAvailableJob();
            return recman()->bonsy->get( $field ) ?? "Invalid field '$field' or unable to fetch content";
        },
    ) );
} );