<?php if( !defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class BonsyRecmanWpSeo {

    private string $permalink = '';


    /**
     * Load SEO for job post
     */
    public function load(): void {

        $this->removeOtherSeoTools();

        # Replace Page Title
        add_filter( 'document_title_parts', function($title_parts) {
            $title_parts['title'] = $this->get( 'name' );
            return $title_parts;
        } );

        # Another try to set page title
        add_filter( 'wp_title', function() {
            return $this->get( 'name' );
        } );

        add_action( 'wp_head', [$this, 'metaData'], 1 );

    }


    /**
     * Inject meta data
     */
    public function metaData(): void {

        # Remove The Page Title
        remove_action( 'wp_head', 'rel_canonical' );

        echo "
            <!-- Job Social Tags -->
            <link rel='canonical' href='$this->permalink' />
            <meta name='description' content='" . $this->getDescription() . "' />
            <meta property='og:title' content='" . $this->getTitle() . "' />
            <meta property='og:description' content='" . $this->getDescription() . "' />
            <meta property='og:url' content='$this->permalink' />
            <meta property='og:site_name' content='" . get_bloginfo( 'name' ) . "' />
            <meta property='og:locale' content='" . get_locale() . "' />
            <meta property='og:type' content='article' />
            <meta name='article:published_time' content='" . $this->get( 'created' ) . "'/>
            <meta name='twitter:title' content='" . $this->getTitle() . "'/>
            <meta name='twitter:description' content='" . $this->getDescription() . "'/>
        ";

        if( $image = $this->get( 'some_image' ) ) {
            echo "
                <meta property='og:image' content='$image' />
                <meta name='twitter:card' content='$image'/>
                <meta name='twitter:image' content='$image'/>
            ";
        }

        echo "<!-- End Job Social Tags -->";

    }


    private function get(string $field): string {
        return recman()->bonsy->get( $field ) ?? '';
    }


    public function setPermalink(string $url): self {
        $this->permalink = $url . '/' . $this->get( 'urn' ) . '/';
        return $this;
    }


    private function getDescription(): string {
        $d = $this->get( 'some_description' ) ?: $this->get( 'excerpt' );
        return trim( substr( strip_tags( $d ), 0, 250 ) );
    }


    private function getTitle(): string {
        $title = $this->get( 'some_title' );
        return $title ?: $this->get( 'name' );
    }


    /**
     * Remove SEO Tools from page
     *
     * @noinspection SpellCheckingInspection
     * @noinspection ClassConstantCanBeUsedInspection
     */
    public function removeOtherSeoTools(): void {

        # Remove The SEO Framework
        if( function_exists( 'the_seo_framework' ) ) {
            try {
                $tsf = the_seo_framework();
                remove_filter( 'wp_title', [$tsf, 'get_wp_title'], 9 );
                remove_filter( 'pre_get_document_title', [$tsf, 'get_document_title'] );
                remove_action( 'wp_head', [$tsf, 'html_output'], 1 );
            } catch( Throwable $e ) {
                # Silence!
            }
        }

        # Remove Yoast SEO Data
        if( class_exists( 'WPSEO_Options' ) ) {

            try {
                add_filter( 'wpseo_frontend_presenter_classes', static function() {

                    $keep[] = 'Yoast\WP\SEO\Presenters\Title_Presenter';
                    $keep[] = 'Yoast\WP\SEO\Presenters\Robots_Presenter';
                    return $keep;
                }, 10, 1 );

                add_filter( 'wpseo_title', function() {
                    return $this->get( 'name' );
                } );
            } catch( Throwable $e ) {
                # Silence
            }

        }

        //        # This will remove all Yoast Data, but also title tag.
        //        if( function_exists( 'YoastSEO' ) ) {
        //            $front_end = YoastSEO()->classes->get( Yoast\WP\SEO\Integrations\Front_End_Integration::class );
        //            remove_action( 'wpseo_head', [ $front_end, 'present_head' ], -9999 );
        //        }

    }


}
