<?php

add_action( 'wp_enqueue_scripts', static function() {
    wp_register_style( 'bonsy-shortcode', false );
    wp_enqueue_style( 'bonsy-shortcode' );
    $css = str_replace( ["\r", "\n", "\t"], '', get_option( 'bonsy_shortcode_custom_css', '' ) );
    $css = preg_replace( '!\s+!', ' ', $css );
    wp_add_inline_style( 'bonsy-shortcode', $css );
} );

add_shortcode( 'job_post_field', static function($params = [], ?string $content = null, string $tag = '') {
    if( !function_exists( 'have_jobposts' ) || !function_exists( 'get_jobpost' ) ) return $content;
    $options = shortcode_atts( ['name' => null], array_change_key_case( is_array( $params ) ? $params : [], CASE_LOWER ), $tag );
    $name = $options['name'] ?? $options['NAME'] ?? null;
    if( !$name || !is_string( $name ) ) return $content;
    return get_jobpost( $name );
} );


add_shortcode( 'job_post_map', static function($params = [], ?string $content = null, string $tag = '') {
    if( !function_exists( 'have_jobposts' ) || !function_exists( 'get_jobpost' ) ) return $content;
    $options = shortcode_atts( ['width' => null, 'height' => null], array_change_key_case( is_array( $params ) ? $params : [], CASE_LOWER ), $tag );
    if( $options['width'] && $options['height'] ) return job_post_map( $options['width'], $options['height'] );
    if( $options['width'] ) return job_post_map( $options['width'] );
    return job_post_map();
} );


add_shortcode( 'job_post_contacts', static function($params = [], ?string $content = null, string $tag = '') {
    if( have_jobpost_object( 'contacts' ) ) {
        $output = '';
        while( have_jobpost_object( 'contacts' ) ) {
            the_jobpost_object();
            $output = "<div class='job_post_contacts'>";
            if( get_jobpost_object( 'image' ) ) {
                $alt = trim( get_jobpost_object( 'firstName' ) . ' ' . get_jobpost_object( 'lastName' ) );
                $output .= "<div class='job_post_contact_image'><img src='" . get_jobpost_object( 'image' ) . "' alt='$alt' /></div>";
            }
            $output .= "<div class='job_post_contact_details'>";
            $output .= "<h4>" . get_jobpost_object( 'name' ) . "</h4>";
            if( $title = get_jobpost_object( 'title' ) ) {
                $output .= "<span class='job_post_contact_title'>$title</span>";
            }
            if( $email = get_jobpost_object( 'email' ) ) {
                $output .= "<span class='job_post_contact_email'>$email</span>";
            }
            if( $phone = get_jobpost_object( 'mobilePhone' ) ) {
                $output .= "<span class='job_post_contact_phone'>$phone</span>";
            }
            $output .= "</div>";
            $output .= "</div>";
        }
        return $output;
    }
    return $content;
} );


/**
 * JobPost Feed Shortcode
 */
add_shortcode( 'job_post_feed', static function($params = [], ?string $content = null, string $tag = '') {

    // Bail early if RecMan WP Plugin isn't active
    if( !function_exists( 'have_jobposts' ) || !function_exists( 'get_jobpost' ) ) return $content;

    // Reset job post loop - important if the job post loop has been used earlier in the page
    reset_jobpost_loop();

    // No need to continue if no job posts.
    if( !have_jobposts() ) return $params['no_job_post_message'] ?? 'No job posts available';

    // Load template or bail early if no template is found
    $template = get_option( 'bonsy_shortcode_html_template' );
    if( !$template || !is_string( $template ) ) return $content;

    // Override default attributes with user attributes
    $options = shortcode_atts( ['count' => 10000000], array_change_key_case( is_array( $params ) ? $params : [], CASE_LOWER ), $tag );

    // Define the count
    $count = 0;

    $html = "";

    while( have_jobposts() ) {

        if( ++$count > (int)$options['count'] ) break;

        the_jobpost();

        $html .= preg_replace_callback( '/{{(.*?)}}/', static function($matches) use ($params) {
            $field = trim( str_replace( ['{{', '}}'], '', $matches[0] ) );
            return $params[$field] ?? get_jobpost( $field );
        }, $template );

    }

    return "<div id='job-post-feed'>$html</div>";

} );


// Some code
add_shortcode( 'job_post_filter', static function($params = [], ?string $content = null, string $tag = '') {

    # Bail if plugin is not active
    if( !function_exists( 'have_jobposts' ) ) return $content;
    if( !function_exists( 'get_jobpost_filters' ) ) return $content;

    // Override default attributes with user attributes
    $options = shortcode_atts( [
        'field' => 'type',
        'title' => 'Job type',
        'reduce' => '1',
        'count' => '1',
    ], array_change_key_case( is_array( $params ) ? $params : [], CASE_LOWER ), $tag );

    $field = (string)$options['field'];
    $title = (string)$options['title'];
    $reduce = (bool)$options['reduce'];
    $show_count = (int)$options['count'];

    # Load all distinct values for the given field
    $items = get_jobpost_filters( $field, $reduce );

    # Bail early if no items
    if( empty( $items ) ) return $content;

    # Show title and create list
    $html = "<div class='job-post-filter'><h3>$title</h3><ul>";

    foreach( $items as $item ) {
        # Generate URL to turn on/off filter
        $url = get_jobpost_filter_url( $field, $item );
        # Set class as active if filter with this item is active.
        $class = (has_jobpost_filter( $field, $item )) ? 'active' : '';

        # Count job posts with this filter
        if( $show_count ) {
            $count = get_jobpost_filter_count( $field, $item );
            if( $count === 0 ) $class .= ' empty';
            $class = trim( $class );
            $name = "$item ($count)";
        } else {
            $name = (string)$item;
        }

        $html .= "<li class='$class'>";
        $html .= "<a href='$url' rel='nofollow'>$name</a>";
        $html .= "</li>";

    }

    $html .= "</ul></div>";

    return $html;

} );


add_shortcode( 'job_post_search', static function($params = [], ?string $content = null, string $tag = '') {

    # Bail if plugin is not active
    if( !function_exists( 'have_jobposts' ) ) return $content;

    $options = shortcode_atts( [
        'label' => 'Search job posts',
        'placeholder' => 'Search job...',
        'button' => 'Search'
    ], array_change_key_case( is_array( $params ) ? $params : [], CASE_LOWER ), $tag );

    $label = (string)$options['label'];
    $placeholder = (string)$options['placeholder'];
    $button = (string)$options['button'];

    $value = $_GET['jobSearch'] ?? '';
    $html = '<form method="get" id="job-post-search-form">';
    if( $label ) {
        $html .= "<label for='jobSearch'>$label</label>";
    }
    $html .= "<input type='text' id='jobSearch' name='jobSearch' value='$value' placeholder='$placeholder'/>";
    if( $button ) {
        $html .= "<button type='submit'>$button</button>";
    }
    $html .= '</form>';
    return $html;
} );
