<?php

/** @noinspection PhpInconsistentReturnPointsInspection */


defined( 'ABSPATH' ) || die;


function get_jobpost_count(bool $filtered = true): int {
    return recman()->bonsy->countJobs( $filtered );
}


function get_jobpost_filters(string $field, bool $filtered = false): array {
    return recman()->bonsy->distinct( $field, $filtered );
}


function get_jobpost_position_count(bool $filtered = true): int {
    return recman()->bonsy->countPosition( $filtered );
}


function has_jobpost_filter(string $key, string $value = null): bool {
    return recman()->bonsy->hasFilter( $key, $value );
}


function reset_jobpost_loop(): void {
    recman()->bonsy->reset_loop();
}

function have_expired_jobposts(int $count = 0, int $offset = 0): bool {
    return recman()->bonsy->have_jobs( $count, $offset, true );
}


function have_jobposts(int $count = 0, int $offset = 0): bool {
    return recman()->bonsy->have_jobs( $count, $offset );
}


function the_jobpost(string $field = null, int $id = null) {
    if( is_null( $field ) ) {
        return recman()->bonsy->the_job();
    }
    echo get_jobpost( $field, $id );
}


function get_jobpost(string $field, int $id = null) {

    if( $field === 'permalink' ) {
        $permalink = recman()->getPermalink( $id );
        if( $permalink ) return $permalink;
        $field = 'url';
    }

    return recman()->bonsy->get( $field, $id );
}


function have_jobpost_object(string $object): bool {
    return recman()->bonsy->have_object( $object );
}


function the_jobpost_object(string $field = null) {
    if( is_null( $field ) ) {
        return recman()->bonsy->the_object();
    }
    echo get_jobpost_object( $field );
}


function get_jobpost_object(string $field) {
    return recman()->bonsy->get_object( $field );
}


function get_jobpost_filter_url(string $key, string $value): string {
    return recman()->bonsy->getFilterUrl( $key, $value );
}


function get_jobpost_filter_count(string $field, string $value): int {
    return recman()->bonsy->getDistinctFilterCount( $field, $value );
}

function job_post_map($width = '450', $height = '250'): string {
    $key = get_option( 'bonsy_google_api_key' );
    if( !$key ) return 'Google Maps API key is not set';
    $address = get_jobpost( 'address1' ) ?: '';
    $address .= ', ' . get_jobpost( 'postalCode' ) ?: '';
    $address .= ' ' . get_jobpost( 'city' ) ?: '';
    $address = urlencode( $address );
    $url = "https://www.google.com/maps/embed/v1/place?key=$key&q=$address";
    return "<iframe width='$width'height='$height' frameborder='0' style='border:0' referrerpolicy='no-referrer-when-downgrade' src='$url' allowfullscreen></iframe>";
}


function single_job_post_loaded(): bool {
    return !is_null( get_jobpost( 'jobPostId' ) );
}


function jobPostIdExist(int $id): bool {
    return recman()->bonsy->jobPostIdIsActive( $id );
}